tic
cd('/BIGDATA1/cqu_yyzhang_1/MATLAB/work/U_IG')
clear; clc;

alpha = 3
beta = 1
N = [200, 400, 800, 1600]
L_N = length(N)
M = 85 %% total number of simulated data sets
Cores = 20 %% number of cores

Alpha_1 = []; Beta_1 = []; Alpha_2 = []; Beta_2 = []; 
A = (1:Cores)
B = [6, 9, 17]
C = setdiff(A, B)
for k = C
	s = string_k(k)
	load(['results/consistency/savefile_', s, '.mat'])
	Alpha_1 = [Alpha_1, eval(['Cell_', s, '{1}'])];
	Beta_1  = [Beta_1,  eval(['Cell_', s, '{2}'])];
	Alpha_2 = [Alpha_2, eval(['Cell_', s, '{3}'])];
	Beta_2  = [Beta_2,  eval(['Cell_', s, '{4}'])];
end
Alpha_1
Beta_1
Alpha_2
Beta_2
size_Alpha_1 = size(Alpha_1)
size_Beta_1 = size(Beta_1)
size_Alpha_2 = size(Alpha_2)
size_Beta_2 = size(Beta_2)

Abs_alpha_1 = abs(Alpha_1 - ones(L_N, M)*alpha);
Abs_beta_1  = abs(Beta_1 -  ones(L_N, M)*beta);
Abs_alpha_2 = abs(Alpha_2 - ones(L_N, M)*alpha);
Abs_beta_2  = abs(Beta_2 -  ones(L_N, M)*beta);

F1 = zeros(L_N, 2); F2 = zeros(L_N, 2);
F = zeros(12, 4);

%% moment estimator
epsilon = 1
F1(:, 1) = mean((Abs_alpha_1 >= epsilon), 2);
F1(:, 2) = mean((Abs_beta_1  >= epsilon), 2);
F1
F(1:4, 1:2) = F1;

epsilon = 0.5
F1(:, 1) = mean((Abs_alpha_1 >= epsilon), 2);
F1(:, 2) = mean((Abs_beta_1  >= epsilon), 2);
F1
F(5:8, 1:2) = F1;

epsilon = 0.2
F1(:, 1) = mean((Abs_alpha_1 >= epsilon), 2);
F1(:, 2) = mean((Abs_beta_1  >= epsilon), 2);
F1
F(9:12, 1:2) = F1;

%% MLE
epsilon = 1
F2(:, 1) = mean((Abs_alpha_2 >= epsilon), 2);
F2(:, 2) = mean((Abs_beta_2  >= epsilon), 2);
F2
F(1:4, 3:4) = F2;

epsilon = 0.5
F2(:, 1) = mean((Abs_alpha_2 >= epsilon), 2);
F2(:, 2) = mean((Abs_beta_2  >= epsilon), 2);
F2
F(5:8, 3:4) = F2;

epsilon = 0.2
F2(:, 1) = mean((Abs_alpha_2 >= epsilon), 2);
F2(:, 2) = mean((Abs_beta_2  >= epsilon), 2);
F2
F(9:12, 3:4) = F2;

F
Generate_Matrix_Latex(F)
save('/BIGDATA1/cqu_yyzhang_1/MATLAB/work/U_IG/results/consistency/F.mat', 'F')

Time_load = toc

